/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.legacy.auth;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.internal_users_db.InternalUser;
import com.floragunn.searchguard.authc.internal_users_db.InternalUsersDatabase;
import com.floragunn.searchguard.authc.legacy.LegacyAuthenticationBackend;
import com.floragunn.searchguard.authc.legacy.LegacyAuthorizationBackend;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.user.Attributes;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.jayway.jsonpath.JsonPath;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.settings.Settings;

public class InternalAuthenticationBackend
implements LegacyAuthenticationBackend,
LegacyAuthorizationBackend {
    private final InternalUsersDatabase internalUsersDatabase;
    private Map<String, JsonPath> attributeMapping;

    InternalAuthenticationBackend(Settings settings, InternalUsersDatabase internalUsersDatabase) {
        this.internalUsersDatabase = internalUsersDatabase;
        this.attributeMapping = Attributes.getAttributeMapping((Settings)settings.getAsSettings("map_db_attrs_to_user_attrs"));
    }

    public boolean exists(User user) throws AuthenticatorUnavailableException {
        if (user == null || this.internalUsersDatabase == null) {
            return false;
        }
        InternalUser internalUser = this.internalUsersDatabase.get(user.getName());
        if (internalUser != null) {
            ImmutableSet searchGuardRoles;
            user.addRoles((Collection)internalUser.getBackendRoles());
            ImmutableMap customAttributes = internalUser.getAttributes();
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            if (customAttributes != null) {
                for (Map.Entry attributeEntry : customAttributes.entrySet()) {
                    attributeMap.put("attr.internal." + (String)attributeEntry.getKey(), attributeEntry.getValue() != null ? attributeEntry.getValue().toString() : null);
                }
            }
            if ((searchGuardRoles = internalUser.getSearchGuardRoles()) != null) {
                user.addSearchGuardRoles((Collection)searchGuardRoles);
            }
            user.addAttributes(attributeMap);
            user.addStructuredAttributesByJsonPath(this.attributeMapping, (Object)customAttributes);
            return true;
        }
        return false;
    }

    public User authenticate(AuthCredentials credentials) throws AuthenticatorUnavailableException {
        InternalUser internalUser = this.internalUsersDatabase.get(credentials.getUsername());
        if (internalUser == null) {
            return null;
        }
        byte[] password = credentials.getPassword();
        if (password == null || password.length == 0) {
            throw new ElasticsearchSecurityException("empty passwords not supported", new Object[0]);
        }
        ByteBuffer wrap = ByteBuffer.wrap(password);
        CharBuffer buf = StandardCharsets.UTF_8.decode(wrap);
        char[] array = new char[buf.limit()];
        buf.get(array);
        Arrays.fill(password, (byte)0);
        try {
            if (OpenBSDBCrypt.checkPassword((String)internalUser.getPasswordHash(), (char[])array)) {
                User user;
                ImmutableSet backendRoles = internalUser.getBackendRoles();
                ImmutableMap customAttributes = internalUser.getAttributes();
                if (customAttributes != null) {
                    credentials = credentials.copy().prefixOldAttributes("attr.internal.", (Map)customAttributes).build();
                }
                ImmutableSet searchGuardRoles = internalUser.getSearchGuardRoles();
                User user2 = user = User.forUser((String)credentials.getUsername()).authDomainInfo(credentials.getAuthDomainInfo().authBackendType(this.getType())).backendRoles((Collection)backendRoles).searchGuardRoles((Collection)searchGuardRoles).attributes(credentials.getStructuredAttributes()).attributesByJsonPath(this.attributeMapping, (Object)customAttributes).oldAttributes(credentials.getAttributes()).build();
                return user2;
            }
            throw new ElasticsearchSecurityException("password does not match", new Object[0]);
        }
        finally {
            Arrays.fill(wrap.array(), (byte)0);
            Arrays.fill(buf.array(), '\u0000');
            Arrays.fill(array, '\u0000');
        }
    }

    public String getType() {
        return "internal";
    }

    public void fillRoles(User user, AuthCredentials credentials) throws ElasticsearchSecurityException, AuthenticatorUnavailableException {
        ImmutableSet roles;
        InternalUser internalUser = this.internalUsersDatabase.get(user.getName());
        if (internalUser != null && (roles = internalUser.getBackendRoles()) != null && !roles.isEmpty() && user != null) {
            user.addRoles((Collection)roles);
        }
    }

    public static class AuthzBackendInfo
    implements TypedComponent.Info<LegacyAuthorizationBackend> {
        private final InternalUsersDatabase internalUsersDatabase;

        public AuthzBackendInfo(InternalUsersDatabase internalUsersDatabase) {
            this.internalUsersDatabase = internalUsersDatabase;
        }

        public Class<LegacyAuthorizationBackend> getType() {
            return LegacyAuthorizationBackend.class;
        }

        public String getName() {
            return "internal";
        }

        public TypedComponent.Factory<LegacyAuthorizationBackend> getFactory() {
            return LegacyComponentFactory.adapt((settings, path) -> new InternalAuthenticationBackend((Settings)settings, this.internalUsersDatabase));
        }
    }

    public static class AuthcBackendInfo
    implements TypedComponent.Info<LegacyAuthenticationBackend> {
        private final InternalUsersDatabase internalUsersDatabase;

        public AuthcBackendInfo(InternalUsersDatabase internalUsersDatabase) {
            this.internalUsersDatabase = internalUsersDatabase;
        }

        public Class<LegacyAuthenticationBackend> getType() {
            return LegacyAuthenticationBackend.class;
        }

        public String getName() {
            return "internal";
        }

        public TypedComponent.Factory<LegacyAuthenticationBackend> getFactory() {
            return LegacyComponentFactory.adapt((settings, path) -> new InternalAuthenticationBackend((Settings)settings, this.internalUsersDatabase));
        }
    }
}

